<?php
include "../includes/header3.php";
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Poppins:wght@300;400;600&display=swap');

:root{
  /* ====== NOSSAS CORES (HEADER3) ====== */
  --neon-cyan:   #00f2ff;
  --neon-purple: #bc13fe;
  --neon-pink:   #ff2bd6;
  --neon-gold:   #ffcc00; /* só para destaque “TEMA ATUAL” */

  --dark-bg: #05070f;
  --glass-bg: rgba(255,255,255,.04);
  --glass-border: rgba(0,242,255,.18);

  --txt: rgba(255,255,255,.92);
  --muted: rgba(255,255,255,.72);

  --page-bg:
    radial-gradient(900px 520px at 12% 18%, rgba(0,242,255,.18), transparent 55%),
    radial-gradient(900px 520px at 72% 14%, rgba(188,19,254,.22), transparent 58%),
    radial-gradient(900px 520px at 58% 72%, rgba(255,43,214,.14), transparent 60%),
    radial-gradient(1200px 700px at 50% 50%, rgba(0,0,0,.20), rgba(0,0,0,.72)),
    linear-gradient(180deg, #05070f, #05060c);
}

/* Blindagem total contra fundo branco (HEADER3 às vezes puxa bg branco do template) */
html, body, #wrapper, #content-wrapper, #content, .container-fluid, .bg-white{
  background: var(--page-bg) !important;
  color: var(--txt) !important;
  font-family: 'Poppins', sans-serif !important;
}

/* Título */
.h3{
  font-family: 'Orbitron', sans-serif !important;
  color: #fff !important;
  text-transform: uppercase;
  letter-spacing: 2px;
  text-shadow: 0 0 12px rgba(0,242,255,.18), 0 0 14px rgba(188,19,254,.18);
}

/* Card “glassmorphism” no estilo do arquivo referência */
.card-futuristic{
  background: var(--glass-bg) !important;
  backdrop-filter: blur(15px);
  -webkit-backdrop-filter: blur(15px);
  border: 1px solid var(--glass-border) !important;
  border-radius: 15px !important;
  box-shadow: 0 10px 30px rgba(0,0,0,.55);
  overflow: hidden;
}

.card-header-futuristic{
  background: linear-gradient(90deg,
    rgba(0,242,255,.10),
    rgba(188,19,254,.08),
    rgba(255,43,214,.06)
  ) !important;
  border-bottom: 1px solid rgba(255,255,255,.10) !important;
  padding: 1.5rem !important;
}

.card-header-futuristic h6{
  font-family: 'Orbitron', sans-serif !important;
  color: var(--neon-cyan) !important;
  text-shadow: 0 0 10px rgba(0,242,255,.20);
  margin: 0;
  text-transform: uppercase;
  letter-spacing: .06em;
}

/* Select e Botão (mesma pegada do ref) */
.form-control-futuristic{
  background: rgba(0,0,0,.45) !important;
  border: 1px solid rgba(255,255,255,.14) !important;
  color: #fff !important;
  border-radius: 8px !important;
  padding: 12px;
  height: 50px;
  font-family: 'Orbitron', sans-serif !important;
  min-width: 250px;
  outline: none !important;
}

.form-control-futuristic:focus{
  border-color: rgba(0,242,255,.40) !important;
  box-shadow: 0 0 0 1px rgba(0,242,255,.18), 0 0 18px rgba(188,19,254,.12) !important;
}

.btn-theme-neon{
  background: transparent !important;
  border: 1px solid rgba(0,242,255,.55) !important;
  color: var(--neon-cyan) !important;
  font-family: 'Orbitron', sans-serif !important;
  text-transform: uppercase;
  height: 50px;
  padding: 0 30px;
  border-radius: 8px;
  transition: .25s;
  cursor: pointer;
  font-size: 0.8rem;
  letter-spacing: .06em;
}

.btn-theme-neon:hover{
  background: rgba(0,242,255,.16) !important;
  color: #fff !important;
  box-shadow: 0 0 22px rgba(0,242,255,.18), 0 0 16px rgba(255,43,214,.10);
  transform: translateY(-1px);
}

/* Galeria de Temas (igual ao ref, mas com nossas cores) */
.image-row{
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
  gap: 25px;
  margin-top: 30px;
}

.theme-card{
  background: rgba(0,0,0,.28);
  border: 1px solid rgba(255,255,255,.10);
  border-radius: 12px;
  padding: 15px;
  text-align: center;
  transition: .25s;
}

.theme-card:hover{
  border-color: rgba(0,242,255,.35);
  transform: translateY(-5px);
  box-shadow: 0 8px 18px rgba(0,242,255,.08);
}

.theme-card img{
  border-radius: 8px;
  margin-bottom: 15px;
  width: 100%;
  height: auto;
  border: 1px solid rgba(255,255,255,0.06);
}

.theme-card p{
  font-family: 'Orbitron', sans-serif !important;
  color: var(--neon-cyan);
  font-size: 0.9rem;
  margin: 0;
  letter-spacing: 1px;
  text-transform: uppercase;
}

/* Tema atual */
.current-label{
  font-family: 'Orbitron', sans-serif !important;
  color: var(--neon-gold);
  text-align: center;
  margin: 20px 0;
  font-size: 1.1rem;
  letter-spacing: .06em;
}

.current-label span{
  text-shadow: 0 0 6px rgba(255,204,0,.25);
}
</style>

<div class="container-fluid pt-4 px-5">
  <h1 class="h3 mb-4">Temas</h1>

  <div class="card card-futuristic shadow mb-4">
    <div class="card-header-futuristic">
      <h6><i class="fa fa-cogs mr-2"></i> Escolher Tema</h6>
    </div>

    <div class="card-body">

      <?php
      /* ====== LÓGICA ORIGINAL (intocada) ====== */
      if ($_SERVER['REQUEST_METHOD'] === 'POST') {
          $selectedOption = $_POST['options'];

          echo "<div style='color:var(--neon-cyan); text-align:center; font-family:Orbitron; margin-bottom:15px; letter-spacing:.05em;'>
                  Você selecionou: " . $selectedOption . "
                </div>";

          $jsonData = file_get_contents("../a/rtx/Setting_$seller_name.json");
          $data = json_decode($jsonData, true);

          $data[0]["RTXSetting"] = "mLayout";
          $data[0]["PanalData"] = $selectedOption;

          $jsonData = json_encode($data, JSON_PRETTY_PRINT);
          file_put_contents("../a/rtx/Setting_$seller_name.json", $jsonData);
      }

      $jsonData = file_get_contents("../a/rtx/Setting_$seller_name.json");
      $data = json_decode($jsonData, true);
      $current_layout = $data[0]["PanalData"];
      ?>

      <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" class="mb-4">
        <div class="d-flex flex-wrap justify-content-center align-items-center" style="gap: 15px;">
          <select name="options" id="options" class="form-control-futuristic">
            <option value="theme_d" <?php if($current_layout == "theme_d") echo "selected"; ?>>Tema 1</option>
            <option value="theme_2" <?php if($current_layout == "theme_2") echo "selected"; ?>>Tema 2</option>
            <option value="theme_3" <?php if($current_layout == "theme_3") echo "selected"; ?>>Tema 3</option>
            <option value="theme_5" <?php if($current_layout == "theme_5") echo "selected"; ?>>Tema 4</option>
          </select>

          <button type="submit" class="btn-theme-neon">
            <i class="fas fa-sync-alt mr-2"></i> Alterar Tema
          </button>
        </div>
      </form>

      <div class="current-label">
        TEMA ATUAL:
        <span><?php echo strtoupper($current_layout); ?></span>
      </div>

      <div class="image-row">
        <div class="theme-card">
          <p>Tema 1</p>
          <img src="../rtx/layout/d.png" alt="theme_d">
        </div>

        <div class="theme-card">
          <p>Tema 2</p>
          <img src="../rtx/layout/2.png" alt="theme_2">
        </div>

        <div class="theme-card">
          <p>Tema 3</p>
          <img src="../rtx/layout/3.png" alt="theme_3">
        </div>

        <div class="theme-card">
          <p>Tema 4</p>
          <img src="../rtx/layout/5.png" alt="theme_5">
        </div>
      </div>

    </div>
  </div>
</div>

<?php include "../includes/footer3.php"; ?>
</body>
</html>
