<?php
include "../includes/header3.php";
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Poppins:wght@300;400;600&display=swap');

:root{
  /* ======= PADRÃO DE CORES DO SEU TEMA (HEADER3) ======= */
  --c-cyan:   #00f2ff;
  --c-purple: #bc13fe;
  --c-pink:   #ff2bd6;
  --c-danger: #ff4b2b;

  --txt: rgba(255,255,255,.92);
  --muted: rgba(255,255,255,.70);
  --stroke: rgba(255,255,255,.12);
  --shadow: 0 18px 60px rgba(0,0,0,.55);

  /* Fundo igual “padrão” */
  --page-bg:
    radial-gradient(900px 520px at 12% 18%, rgba(0,242,255,.18), transparent 55%),
    radial-gradient(900px 520px at 72% 14%, rgba(188,19,254,.22), transparent 58%),
    radial-gradient(900px 520px at 58% 72%, rgba(255,43,214,.14), transparent 60%),
    radial-gradient(1200px 700px at 50% 50%, rgba(0,0,0,.25), rgba(0,0,0,.70)),
    linear-gradient(180deg, #05070f, #05060c);
}

/* ========= AQUI ESTÁ A CORREÇÃO DO “BRANCO” ========= */
/* força o mesmo background do tema em todos os wrappers do template */
html, body, #wrapper, #content-wrapper, #content, .bg-white, .container-fluid{
  background: var(--page-bg) !important;
  color: var(--txt) !important;
  font-family: 'Poppins', sans-serif !important;
}

/* evita áreas claras do SB Admin */
.card, .card-body, .table-responsive{
  background-color: transparent !important;
}

/* Título */
.h3{
  font-family: 'Orbitron', sans-serif !important;
  color: rgba(255,255,255,.96) !important;
  text-transform: uppercase;
  letter-spacing: 2px;
  text-shadow: 0 0 12px rgba(0,242,255,.16), 0 0 14px rgba(188,19,254,.18);
}

/* Card “glass” */
.card-futuristic{
  background: linear-gradient(180deg, rgba(255,255,255,.10), rgba(255,255,255,.04)) !important;
  backdrop-filter: blur(16px);
  -webkit-backdrop-filter: blur(16px);
  border: 1px solid rgba(0,242,255,.18) !important;
  border-radius: 15px !important;
  box-shadow: var(--shadow);
  overflow: hidden;
}

.card-header-futuristic{
  background: linear-gradient(90deg, rgba(0,242,255,.10), rgba(188,19,254,.08), rgba(255,43,214,.06)) !important;
  border-bottom: 1px solid rgba(255,255,255,.10) !important;
  padding: 1.5rem !important;
}

.card-header-futuristic h6{
  font-family: 'Orbitron', sans-serif !important;
  color: rgba(0,242,255,.92) !important;
  text-shadow: 0 0 10px rgba(0,242,255,.18);
  margin: 0;
  text-transform: uppercase;
  letter-spacing: .06em;
}

/* Texto “Atualmente em uso” */
.meta-current{
  font-family: Orbitron, sans-serif;
  font-size: 1.1rem;
  margin-bottom: 20px;
  color: rgba(255,255,255,.92);
}
.meta-current span{
  color: rgba(255,255,255,.92);
  opacity: .9;
}

/* Inputs */
.input-group-custom{
  display:flex;
  align-items:center;
  gap:15px;
  width:100%;
  max-width:800px;
}

.form-control-futuristic{
  background: rgba(0,0,0,.35) !important;
  border: 1px solid rgba(255,255,255,.14) !important;
  color: rgba(255,255,255,.95) !important;
  border-radius: 8px !important;
  padding: 12px;
  height: 50px;
  flex-grow: 1;
  outline: none !important;
  box-shadow: none !important;
}
.form-control-futuristic:focus{
  border-color: rgba(0,242,255,.40) !important;
  box-shadow: 0 0 0 1px rgba(0,242,255,.18), 0 0 18px rgba(188,19,254,.10) !important;
}

/* Botão padrão do tema */
.btn-theme{
  background: rgba(0,242,255,.10) !important;
  border: 1px solid rgba(0,242,255,.35) !important;
  color: rgba(255,255,255,.95) !important;
  font-family: 'Orbitron', sans-serif !important;
  text-transform: uppercase;
  height: 50px;
  padding: 0 30px;
  border-radius: 8px;
  transition: .25s;
  cursor: pointer;
  display:flex;
  align-items:center;
  justify-content:center;
  min-width:160px;
  font-size:.8rem;
  letter-spacing:.06em;
  box-shadow: 0 0 22px rgba(0,242,255,.10);
}
.btn-theme:hover{
  background: rgba(0,242,255,.16) !important;
  box-shadow: 0 0 26px rgba(0,242,255,.16), 0 0 18px rgba(255,43,214,.10);
  transform: translateY(-1px);
}

input[type="radio"]{
  accent-color: var(--c-cyan);
  cursor: pointer;
}

/* Preview ajustável (sem “campo grande fixo”) */
.preview-container{
  border: 2px solid rgba(0,242,255,.18);
  border-radius: 12px;
  overflow: hidden;
  margin: 20px 0;
  background: rgba(0,0,0,.35);
  box-shadow: 0 0 22px rgba(0,242,255,.10);
  display: inline-block;     /* se ajusta ao conteúdo */
  max-width: 100%;
}
.preview-image{
  display:block;
  width: auto;
  max-width: 100%;
  height: auto;
  max-height: 300px; /* igual ao layout referência */
  object-fit: contain;
}

#url-form{ display:none; }

label{
  font-weight: 600;
  color: rgba(0,242,255,.92);
  margin-bottom: 10px;
  display: block;
  text-transform: uppercase;
  font-size: .8rem;
  letter-spacing: .05em;
}
</style>

<div class="container-fluid pt-4 px-5">
  <h1 class="h3 mb-4"> Image Background</h1>

  <div class="card card-futuristic shadow mb-4">
    <div class="card-header-futuristic">
      <h6><i class="fa fa-cogs mr-2"></i> Escolher Banner</h6>
    </div>

    <div class="card-body p-4">
      <?php
      $jsonFilex = "../a/rtx/image_filenames_$seller_name.json";
      $jsonDatax = file_get_contents($jsonFilex);
      $imageDatax = json_decode($jsonDatax, true);

      $filenamex = $imageDatax[0]['ImageName'];
      $uploadmethord = $imageDatax[0]['Upload_type'];

      if ($uploadmethord == "by_file") {
          $string = $filenamex;
          $firstLetterRemoved = substr($string, 1);
          $imageFilex = "$firstLetterRemoved";
          $methord = " Upload Method";
      } elseif ($uploadmethord == "by_url") {
          $imageFilex = "$filenamex";
          $methord = " URL Method";
      } else {
          $imageFilex = "https://c4.wallpaperflare.com/wallpaper/159/71/731/errors-minimalism-typography-red-wallpaper-preview.jpg";
          $methord = "";
      }
      ?>

      <h3 class="meta-current">Atualmente em uso: <span><?php echo $methord; ?></span></h3>

      <div class="mb-4">
        <input type="radio" name="upload-type" id="upload-radio" checked>
        Definir plano de fundo usando arquivo &nbsp;&nbsp;
        <input type="radio" name="upload-type" id="url-radio">
        Definir plano de fundo usando URL
      </div>

      <div class="preview-container">
        <?php if($uploadmethord == "by_file" ) { ?>
          <img class="preview-image" src="../<?php echo $imageFilex; ?>" alt="Uploaded Image">
        <?php } else { ?>
          <img class="preview-image" src="<?php echo $imageFilex; ?>" alt="Uploaded Image">
        <?php } ?>
      </div>

      <?php
      /* ====== FUNÇÕES/LÓGICA INTACTAS ====== */

      if (isset($_POST['upload'])) {

          $selectedFiles = ['logo.png', 'index.php', 'iimg.json', 'filenames.json', 'binding_dark.webp', 'bg.jpg', 'api.php', 'favicon.ico', 'logo_ne.png' , '.htaccess'];
          $folderPath = "../rtx/Img/$seller_name/";

          if (!file_exists($folderPath)) {
              if (!mkdir($folderPath, 0777, true)) {
                  echo 'Erro ao criar a pasta.';
              }
          }

          $files = scandir($folderPath);
          foreach ($files as $file) {
              if ($file !== '.' && $file !== '..') {
                  $filePath = $folderPath . $file;
                  if (!in_array($file, $selectedFiles)) {
                      unlink($filePath);
                  }
              }
          }

          if (isset($_FILES['image'])) {
              $file = $_FILES['image'];
              $fileType = $file['type'];
              $fileTemp = $file['tmp_name'];

              $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
              if (in_array($fileType, $allowedTypes)) {

                  $uploadPath = "../rtx/Img/$seller_name/";
                  $fileName = uniqid() . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
                  $destination = $uploadPath . $fileName;

                  if (move_uploaded_file($fileTemp, $destination)) {
                      echo "<script>window.location.href='mRTXBGImage.php';</script>";

                      $jsonFilePath = "../a/rtx/image_filenames_$seller_name.json";
                      $jsonData = json_encode([["ImageName" => "../rtx/Img/$seller_name/" . $fileName, 'Upload_type' => 'by_file']]);
                      file_put_contents($jsonFilePath, $jsonData);
                  } else {
                      echo 'Failed to move the uploaded file.';
                  }

              } else {
                  echo 'Invalid file type. Only JPEG, PNG, and GIF images are allowed.';
              }
          }
      }

      if (isset($_POST['url-submit'])) {
          $imageUrl = $_POST['image-url'];

          if (filter_var($imageUrl, FILTER_VALIDATE_URL)) {
              $jsonFilePath = "../a/rtx/image_filenames_$seller_name.json";

              $newImageData = [
                  'ImageName' => $imageUrl,
                  'Upload_type' => 'by_url'
              ];

              $jsonData = file_get_contents($jsonFilePath);
              $imageData = json_decode($jsonData, true);

              $imageData[0] = $newImageData;

              $jsonData = json_encode($imageData);

              if (file_put_contents($jsonFilePath, $jsonData)) {
                  echo "<script>window.location.href='mRTXBGImage.php';</script>";
              } else {
                  echo 'Failed to save the image data to the JSON file.';
              }
          } else {
              echo 'Invalid URL.';
          }
      }
      ?>

      <div class="mt-4">
        <form method="post" enctype="multipart/form-data" id="upload-form">
          <label for="image">Selecione uma imagem para carregar:</label>
          <div class="input-group-custom">
            <input class="form-control-futuristic" type="file" name="image" id="image" accept="image/jpeg, image/png, image/gif">
            <button class="btn-theme" type="submit" name="upload">Upload</button>
          </div>
        </form>

        <form method="post" id="url-form">
          <label for="image-url">Selecione um URL de imagem:</label>
          <div class="input-group-custom">
            <input class="form-control-futuristic" type="text" name="image-url" id="image-url" placeholder="https://example.com/image.jpg">
            <button class="btn-theme" type="submit" name="url-submit">Enviar URL</button>
          </div>
        </form>
      </div>

      <script>
        const uploadRadio = document.getElementById('upload-radio');
        const urlRadio = document.getElementById('url-radio');
        const uploadForm = document.getElementById('upload-form');
        const urlForm = document.getElementById('url-form');

        uploadRadio.addEventListener('change', () => {
          uploadForm.style.display = 'block';
          urlForm.style.display = 'none';
        });

        urlRadio.addEventListener('change', () => {
          uploadForm.style.display = 'none';
          urlForm.style.display = 'block';
        });
      </script>

    </div>
  </div>
</div>

<?php include "../includes/footer3.php"; ?>
</body>
</html>
