<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/**
 * 1) Abre o banco principal
 */
$db = new SQLite3('../a/.eggziedb.db');

/**
 * 2) Anti-lock (MUITO importante)
 */
$db->busyTimeout(15000);
$db->exec("PRAGMA journal_mode = WAL;");
$db->exec("PRAGMA synchronous = NORMAL;");
$db->exec("PRAGMA busy_timeout = 15000;");

/**
 * 3) Ajuste de tabela: você usa extra e id_ref no INSERT,
 * então a tabela precisa ter essas colunas.
 * - Se a tabela já existia antiga, isso NÃO altera a estrutura.
 * - Mais abaixo eu coloquei um “ALTER TABLE” seguro.
 */
$db->exec('CREATE TABLE IF NOT EXISTS sub_revenda (
    id INTEGER PRIMARY KEY,
    nome TEXT NOT NULL,
    usuario TEXT NOT NULL,
    senha TEXT NOT NULL,
    registro TIMESTAMP NOT NULL,
    macs INTEGER NOT NULL,
    registrado_por TEXT NOT NULL,
    extra TEXT,
    id_ref INTEGER
);');

// Se a tabela já existia sem as colunas, tenta adicionar:
@$db->exec("ALTER TABLE sub_revenda ADD COLUMN extra TEXT;");
@$db->exec("ALTER TABLE sub_revenda ADD COLUMN id_ref INTEGER;");

$res = $db->query('SELECT * FROM sub_revenda');

include '../includes/header2.php';

$index = isset($_GET['index']) ? $_GET['index'] : "";

/**
 * Função simples para exec com tentativas (ajuda MUITO em concorrência)
 */
function execRetry(SQLite3 $db, string $sql, int $tries = 10, int $sleepMs = 250): bool {
    for ($i = 0; $i < $tries; $i++) {
        $ok = @$db->exec($sql);
        if ($ok) return true;

        $err = strtolower($db->lastErrorMsg());
        if (strpos($err, 'database is locked') !== false) {
            usleep($sleepMs * 1000);
            continue;
        }
        return false;
    }
    return false;
}

if (isset($_POST['submit'])) {

    // Pegando dados do formulário
    $macs_cust = (int)($_POST['macs'] ?? 0);
    $usuario   = trim($_POST['username'] ?? '');
    $nome      = trim($_POST['nome'] ?? '');
    $senha     = trim($_POST['password'] ?? '');
    $Descricao = trim($_POST['Descricao'] ?? '');

    // Validações básicas
    if ($macs_cust < 1) {
        echo "<script>alert('Número de MACs deve ser maior que 0!');window.location.href='sub_revenda.php';</script>";
        exit;
    }

    if ($usuario === '' || $nome === '' || $senha === '' || $Descricao === '') {
        echo "<script>alert('Preencha todos os campos!');window.location.href='sub_revenda.php';</script>";
        exit;
    }

    if (strtoupper($usuario) === "ADM") {
        echo "<script>alert('Usuário ADM não é permitido!');window.location.href='sub_revenda.php';</script>";
        exit;
    }

    /**
     * 4) Pegar macs do revendedor (prepare evita SQL injection)
     */
    $stmt = $db->prepare("SELECT macs FROM revenda WHERE usuario = :u LIMIT 1");
    $stmt->bindValue(":u", $seller_name, SQLITE3_TEXT);
    $rs = $stmt->execute();
    $row = $rs->fetchArray(SQLITE3_ASSOC);
    $rs->finalize();
    $stmt->close();

    $macs = (int)($row['macs'] ?? 0);

    if ($macs_cust > $macs) {
        echo "<script>alert('Você não possui MACs suficientes!');window.location.href='sub_revenda.php';</script>";
        exit;
    }

    /**
     * 5) Verifica se já existe usuario em revenda ou sub_revenda
     */
    $stmt = $db->prepare("SELECT COUNT(*) as count FROM revenda WHERE usuario = :u");
    $stmt->bindValue(":u", $usuario, SQLITE3_TEXT);
    $rs = $stmt->execute();
    $row = $rs->fetchArray(SQLITE3_ASSOC);
    $rs->finalize();
    $stmt->close();
    $count1 = (int)($row['count'] ?? 0);

    $stmt = $db->prepare("SELECT COUNT(*) as count FROM sub_revenda WHERE usuario = :u");
    $stmt->bindValue(":u", $usuario, SQLITE3_TEXT);
    $rs = $stmt->execute();
    $row = $rs->fetchArray(SQLITE3_ASSOC);
    $rs->finalize();
    $stmt->close();
    $count2 = (int)($row['count'] ?? 0);

    if (($count1 + $count2) > 0) {
        echo "<script>alert('Já existe um sub revenda/revenda com esse usuário, escolha outro!');window.location.href='sub_revenda.php';</script>";
        exit;
    }

    /**
     * 6) Calcula id_ref (se existir id_ref nas tabelas)
     */
    $query = "SELECT MAX(max_value) AS maior_valor FROM (
        SELECT MAX(id_ref) AS max_value FROM revenda
        UNION
        SELECT MAX(id_ref) AS max_value FROM sub_revenda
    ) as combined";
    $result = $db->query($query);
    $row = $result->fetchArray(SQLITE3_ASSOC);
    $ref_id = (int)($row['maior_valor'] ?? 0);
    $ref_id++;

    /**
     * 7) Aqui é a parte que trava (INSERT + UPDATE)
     * -> vamos usar TRANSACAO para evitar lock.
     */
    $registro = date('Y/m/d');

    $db->exec("BEGIN IMMEDIATE;");

    try {
        // INSERT com prepared
        $stmt = $db->prepare("
            INSERT INTO sub_revenda(nome, usuario, senha, registro, macs, registrado_por, extra, id_ref)
            VALUES(:nome, :usuario, :senha, :registro, :macs, :registrado_por, :extra, :id_ref)
        ");
        $stmt->bindValue(":nome", $nome, SQLITE3_TEXT);
        $stmt->bindValue(":usuario", $usuario, SQLITE3_TEXT);
        $stmt->bindValue(":senha", $senha, SQLITE3_TEXT);
        $stmt->bindValue(":registro", $registro, SQLITE3_TEXT);
        $stmt->bindValue(":macs", $macs_cust, SQLITE3_INTEGER);
        $stmt->bindValue(":registrado_por", $seller_name, SQLITE3_TEXT);
        $stmt->bindValue(":extra", $Descricao, SQLITE3_TEXT);
        $stmt->bindValue(":id_ref", $ref_id, SQLITE3_INTEGER);

        $ok = $stmt->execute();
        if ($ok === false) {
            throw new Exception("Falha no INSERT: " . $db->lastErrorMsg());
        }
        $stmt->close();

        // UPDATE com proteção (evita saldo negativo se clicar duas vezes rápido)
        $stmt = $db->prepare("
            UPDATE revenda
            SET macs = macs - :qtd
            WHERE usuario = :u AND macs >= :qtd
        ");
        $stmt->bindValue(":qtd", $macs_cust, SQLITE3_INTEGER);
        $stmt->bindValue(":u", $seller_name, SQLITE3_TEXT);

        $ok2 = $stmt->execute();
        if ($ok2 === false) {
            throw new Exception("Falha no UPDATE: " . $db->lastErrorMsg());
        }
        $stmt->close();

        if ($db->changes() < 1) {
            throw new Exception("Saldo insuficiente (concorrência).");
        }

        $db->exec("COMMIT;");
    } catch (Exception $e) {
        $db->exec("ROLLBACK;");
        echo "<script>alert('Erro: ".addslashes($e->getMessage())."');window.location.href='sub_revenda.php';</script>";
        exit;
    }

    // Fecha o DB principal
    $db->close();
    unset($db);

    /**
     * 8) Criar arquivos default (sem mexer no DB principal)
     */
    $caminho_arquivo = "../a/rtx/";
    @file_put_contents($caminho_arquivo . "Setting_$usuario.json", file_get_contents($caminho_arquivo . "Setting.json"));
    @file_put_contents($caminho_arquivo . "logo_filenames_$usuario.json", file_get_contents($caminho_arquivo . "logo_filenames.json"));
    @file_put_contents($caminho_arquivo . "image_filenames_$usuario.json", file_get_contents($caminho_arquivo . "image_filenames.json"));
    @file_put_contents("../a/note_$usuario.json", file_get_contents("../a/note.json"));
    @file_put_contents("../a/qrcode_$usuario.json", file_get_contents("../a/qrcode.json"));
    @file_put_contents("../api/theme_$usuario.json", file_get_contents("../api/theme.json"));

    /**
     * 9) ADS default
     * Você estava usando $adb (que não existe). Vamos abrir o DB de ads corretamente.
     * ⚠️ Ajuste o caminho abaixo para o DB real onde fica a tabela "ads".
     * Se você não souber o caminho, me diga onde está a tabela ads.
     */
    // EXEMPLO (troque o caminho se precisar):
    // $adb = new SQLite3('../a/ads.db');
    // $adb->busyTimeout(15000);
    // $adb->exec("PRAGMA journal_mode=WAL;");
    // $adb->exec("PRAGMA busy_timeout=15000;");
    // $stmt = $adb->prepare("INSERT INTO ads (title, url, owner) VALUES(:t, :u, :o)");
    // $stmt->bindValue(":t", "Exemplo", SQLITE3_TEXT);
    // $stmt->bindValue(":u", "https://meubox.painelmaster.lol/img/banners/67a02a3a6c9ec.jpeg", SQLITE3_TEXT);
    // $stmt->bindValue(":o", $usuario, SQLITE3_TEXT);
    // $stmt->execute();
    // $stmt->close();
    // $adb->close();

    /**
     * 10) Canal default - usa outro banco (intro.db)
     * Aqui eu NÃO sobrescrevo $db pra não confundir.
     */
    $introDb = new SQLite3('../api/intro.db');
    $introDb->busyTimeout(15000);
    $introDb->exec("PRAGMA journal_mode = WAL;");
    $introDb->exec("PRAGMA synchronous = NORMAL;");
    $introDb->exec("PRAGMA busy_timeout = 15000;");

    $stmt = $introDb->prepare("INSERT INTO intro (url, owner) VALUES (:url, :owner)");
    $stmt->bindValue(":url", "Nenhuma URL definida", SQLITE3_TEXT);
    $stmt->bindValue(":owner", $usuario, SQLITE3_TEXT);
    $stmt->execute();
    $stmt->close();
    $introDb->close();

    echo "<script>window.location.href='sub_revenda.php';</script>";
    exit;
}

?>

<div class="container-fluid">
    <h1 class="h3 mb-1 text-gray-800">Painel de Sub Revenda</h1>
    <div class="card border-left-primary shadow h-100 card shadow mb-4">
    </div>

    <div class="card border-left-primary shadow h-100 card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary2"><i class="fas fa-user"></i> Detalhes do Sub Revenda:</h6>
        </div>
        <div class="card-body">
            <form method="post">
                <div class="form-group">
                    <label class="control-label" for="nome">
                        <strong>Nome</strong>
                    </label>
                    <div class="input-group">
                        <input class="form-control text-primary" id="nome" name="nome" placeholder="Digite o Nome" type="text" value="" required/>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label" for="title">
                        <strong>MACs</strong>
                    </label>
                    <div class="input-group">
                        <input type="number" min="1" max="999" class="form-control text-primary" name="macs" placeholder="Numero de MACs" id="macs" value="" required/>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label" for="username">
                        <strong>Usuario</strong>
                    </label>
                    <div class="input-group">
                        <input type="text" class="form-control text-primary" name="username" placeholder="Enter Username" id="username" required/>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label" for="password">
                        <strong>Senha</strong>
                    </label>
                    <div class="input-group">
                        <input type="text" class="form-control text-primary" name="password" placeholder="Enter Password" id="password" required/>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label" for="Descricao">
                        <strong>Descricao</strong>
                    </label>
                    <div class="input-group">
                        <input class="form-control text-primary" id="Descricao" name="Descricao" placeholder="Digite a Descricao" type="text" value="" required/>
                    </div>
                </div>

                <b style="color: red;">Atenção: O numero de MACs do sub-revenda serão descontados do seu numero de MACs!</b><br><br>

                <div class="form-group">
                    <div>
                        <button class="btn btn-success btn-icon-split" name="submit" type="submit">
                            <span class="icon text-white-50"><i class="fas fa-check"></i></span><span class="text">Submit</span>
                        </button>
                    </div>
                </div>

            </form>
        </div>
    </div>
</div>

<script>
$('#confirm-delete').on('show.bs.modal', function(e) {
    $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
});
</script>

</body>
<?php
include '../includes/footer2.php';
?>
</html>
