<?php
include "includes/header.php";
?>

<style>
    /* Importação das fontes para garantir que carreguem corretamente */
    @import url('https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Poppins:wght@300;400;600&display=swap');

    :root {
        --neon-blue: #00d4ff;
        --dark-bg: #06090c;
        --card-glass: rgba(13, 18, 24, 0.95);
        --border-glass: rgba(0, 212, 255, 0.2);
    }

    /* Reset de fundo para eliminar qualquer rastro de branco */
    body, #wrapper, #content-wrapper, #content {
        background-color: var(--dark-bg) !important;
        color: #f8f9fc;
        font-family: 'Poppins', sans-serif;
    }

    /* Card com efeito Glassmorphism */
    .card-futuristic {
        background: var(--card-glass) !important;
        backdrop-filter: blur(15px);
        border: 1px solid var(--border-glass) !important;
        border-radius: 15px !important;
        box-shadow: 0 10px 30px rgba(0,0,0,0.5);
    }

    .card-header-futuristic {
        background: rgba(0, 212, 255, 0.03) !important;
        border-bottom: 1px solid var(--border-glass) !important;
        padding: 1.5rem !important;
    }

    /* Títulos usando Orbitron (Igual ao image.php) */
    .card-header-futuristic h6, .page-main-title {
        font-family: 'Orbitron', sans-serif;
        color: var(--neon-blue) !important;
        text-shadow: 0 0 10px var(--neon-blue);
        letter-spacing: 2px;
        margin: 0;
        text-transform: uppercase;
    }

    .status-title {
        font-family: 'Orbitron', sans-serif;
        font-size: 1rem;
        color: var(--neon-blue);
        margin-bottom: 15px;
    }

    /* Seletores de Método */
    .method-selector {
        background: rgba(255, 255, 255, 0.05);
        padding: 15px;
        border-radius: 10px;
        border: 1px solid var(--border-glass);
        margin-bottom: 20px;
    }

    .custom-control-label {
        cursor: pointer;
        color: #e0e0e0;
        font-weight: 300;
    }

    /* Preview do Logo com Neon Glow */
    .preview-container {
        text-align: center;
        margin: 20px 0;
        padding: 15px;
        background: rgba(0,0,0,0.2);
        border-radius: 10px;
    }

    .preview-image {
        border: 2px solid var(--neon-blue);
        border-radius: 10px;
        box-shadow: 0 0 20px rgba(0, 212, 255, 0.3);
        max-width: 100%;
        max-height: 200px;
        height: auto;
        background: transparent;
    }

    /* Inputs e Botões Padronizados */
    .form-control-futuristic {
        background: rgba(0, 0, 0, 0.5) !important;
        border: 1px solid var(--border-glass) !important;
        color: #fff !important;
        padding: 10px;
        border-radius: 8px;
        font-family: 'Poppins', sans-serif;
    }

    .btn-neon {
        background: transparent;
        border: 1px solid var(--neon-blue);
        color: var(--neon-blue) !important;
        font-family: 'Orbitron', sans-serif; /* Fonte Orbitron no botão */
        transition: 0.4s;
        padding: 10px 25px;
        border-radius: 8px;
        text-transform: uppercase;
        font-size: 0.85rem;
        letter-spacing: 1px;
    }

    .btn-neon:hover {
        background: var(--neon-blue);
        color: #000 !important;
        box-shadow: 0 0 20px var(--neon-blue);
    }

    #url-form { display: none; }
</style>

<div class="container-fluid pt-4 px-5">
    <h1 class="page-main-title h3 mb-4">Gerenciamento de logotipo</h1>

    <div class="row">
        <div class="col-lg-10 mx-auto">
            <div class="card card-futuristic shadow mb-4">
                <div class="card-header-futuristic">
                    <h6><i class="fa fa-pen-nib mr-2"></i> Alterar Logotipo</h6>
                </div>
                <div class="card-body">
                    <?php
                    $jsonFilex = './a/rtx/logo_filenames.json';
                    $jsonDatax = file_get_contents($jsonFilex);
                    $imageDatax = json_decode($jsonDatax, true);
                    
                    $filenamex = $imageDatax[0]['ImageName'];
                    $uploadmethord = $imageDatax[0]['Upload_type'];
                    
                    if ($uploadmethord == "by_file") {
                        $imageFilex = substr($filenamex, 1);
                        $methord = "Arquivo Local";
                    } elseif ($uploadmethord == "by_url") {
                        $imageFilex = $filenamex;
                        $methord = "Link externo";
                    } else {
                        $imageFilex = "https://c4.wallpaperflare.com/wallpaper/159/71/731/errors-minimalism-typography-red-wallpaper-preview.jpg";
                        $methord = "Nenhum";
                    }

                    echo '<h3 class="status-title">Configuração Atual: <span style="color:#fff; font-family:\'Poppins\'">' . $methord . '</span></h3>';
                    ?>

                    <div class="method-selector">
                        <div class="custom-control custom-radio custom-control-inline">
                            <input type="radio" name="upload-type" id="upload-radio" class="custom-control-input" checked>
                            <label class="custom-control-label" for="upload-radio">Usar arquivo local</label>
                        </div>
                        <div class="custom-control custom-radio custom-control-inline">
                            <input type="radio" name="upload-type" id="url-radio" class="custom-control-input">
                            <label class="custom-control-label" for="url-radio">Usar URL externa</label>
                        </div>
                    </div>

                    <div class="preview-container">
                        <img class="preview-image" src="<?php echo $imageFilex; ?>" alt="Logo Ativo">
                    </div>

                    <?php
                    if (isset($_POST['upload'])) {
                        $selectedFiles = ['logo.png', 'index.php', 'iimg.json', 'filenames.json', 'binding_dark.webp', 'bg.jpg', 'api.php', 'favicon.ico', 'logo_ne.png' , '.htaccess'];
                        $folderPath = './rtx/logo/ADM/';
                        $files = scandir($folderPath);
                        foreach ($files as $file) {
                            if ($file !== '.' && $file !== '..') {
                                if (!in_array($file, $selectedFiles)) { @unlink($folderPath . $file); }
                            }
                        }
                        if (isset($_FILES['image'])) {
                            $file = $_FILES['image'];
                            if (in_array($file['type'], ['image/jpeg', 'image/png', 'image/gif'])) {
                                $uploadPath = './rtx/logo/ADM/';
                                $fileName = uniqid() . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
                                $destination = $uploadPath . $fileName;
                                if (move_uploaded_file($file['tmp_name'], $destination)) {
                                    $jsonData = json_encode([["ImageName" => "../rtx/logo/ADM/" . $fileName, 'Upload_type' => 'by_file']]);
                                    file_put_contents($jsonFilex, $jsonData);
                                    echo "<script>window.location.href='mRTXBGlogo.php';</script>";
                                }
                            }
                        }
                    }

                    if (isset($_POST['url-submit'])) {
                        $imageUrl = $_POST['image-url'];
                        if (filter_var($imageUrl, FILTER_VALIDATE_URL)) {
                            $jsonData = json_encode([['ImageName' => $imageUrl, 'Upload_type' => 'by_url']]);
                            file_put_contents($jsonFilex, $jsonData);
                            echo "<script>window.location.href='mRTXBGlogo.php';</script>";
                        }
                    }
                    ?>

                    <div id="upload-form" class="mt-4">
                        <form method="post" enctype="multipart/form-data">
                            <label class="d-block mb-2 small text-uppercase">Selecionar arquivo de imagem:</label>
                            <input class="form-control-futuristic mb-3" type="file" name="image" accept="image/*" style="width: 100%;">
                            <button class="btn btn-neon" type="submit" name="upload">Fazer Upload</button>
                        </form>
                    </div>

                    <div id="url-form" class="mt-4">
                        <form method="post">
                            <label class="d-block mb-2 small text-uppercase">Insira a URL da imagem abaixo:</label>
                            <input class="form-control-futuristic mb-3" type="text" name="image-url" placeholder="https://exemplo.com/logo.png" style="width: 100%;">
                            <button class="btn btn-neon" type="submit" name="url-submit">Enviar via URL</button>
                        </form>
                    </div>

                    <script>
                        const uploadRadio = document.getElementById('upload-radio');
                        const urlRadio = document.getElementById('url-radio');
                        const uploadForm = document.getElementById('upload-form');
                        const urlForm = document.getElementById('url-form');

                        uploadRadio.addEventListener('change', () => {
                            uploadForm.style.display = 'block';
                            urlForm.style.display = 'none';
                        });

                        urlRadio.addEventListener('change', () => {
                            uploadForm.style.display = 'none';
                            urlForm.style.display = 'block';
                        });
                    </script>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
include "includes/footer.php";
?>