<?php
include "includes/header.php";
?>

<style>
    /* Importação das fontes padrão */
    @import url('https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Poppins:wght@300;400;600&display=swap');

    :root {
        --neon-blue: #00d4ff;
        --dark-bg: #06090c;
        --card-glass: rgba(13, 18, 24, 0.95);
        --border-glass: rgba(0, 212, 255, 0.2);
    }

    /* Eliminação total de fundos brancos */
    body, #wrapper, #content-wrapper, #content {
        background-color: var(--dark-bg) !important;
        color: #f8f9fc;
        font-family: 'Poppins', sans-serif;
    }

    .card-futuristic {
        background: var(--card-glass) !important;
        backdrop-filter: blur(15px);
        border: 1px solid var(--border-glass) !important;
        border-radius: 15px !important;
        box-shadow: 0 10px 30px rgba(0,0,0,0.5);
    }

    .card-header-futuristic {
        background: rgba(0, 212, 255, 0.03) !important;
        border-bottom: 1px solid var(--border-glass) !important;
        padding: 1.5rem !important;
    }

    /* Títulos Orbitron */
    .card-header-futuristic h6, .page-main-title {
        font-family: 'Orbitron', sans-serif;
        color: var(--neon-blue) !important;
        text-shadow: 0 0 10px var(--neon-blue);
        letter-spacing: 2px;
        margin: 0;
        text-transform: uppercase;
    }

    /* Estilização do Formulário de Seleção */
    .selection-box {
        background: rgba(255, 255, 255, 0.05);
        padding: 25px;
        border-radius: 12px;
        border: 1px solid var(--border-glass);
        margin-bottom: 30px;
        text-align: center;
    }

    .form-control-futuristic {
        background: rgba(0, 0, 0, 0.6) !important;
        border: 1px solid var(--border-glass) !important;
        color: #fff !important;
        padding: 10px;
        border-radius: 8px;
        font-family: 'Poppins', sans-serif;
        min-width: 200px;
        outline: none;
    }

    .btn-neon {
        background: transparent;
        border: 1px solid var(--neon-blue);
        color: var(--neon-blue) !important;
        font-family: 'Orbitron', sans-serif;
        transition: 0.4s;
        padding: 10px 30px;
        border-radius: 8px;
        text-transform: uppercase;
        letter-spacing: 1px;
        cursor: pointer;
    }

    .btn-neon:hover {
        background: var(--neon-blue);
        color: #000 !important;
        box-shadow: 0 0 20px var(--neon-blue);
    }

    /* Grid de Imagens dos Temas */
    .themes-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 25px;
        margin-top: 20px;
    }

    .theme-card {
        background: rgba(0, 0, 0, 0.3);
        border: 1px solid var(--border-glass);
        border-radius: 12px;
        padding: 15px;
        text-align: center;
        transition: 0.3s;
    }

    .theme-card:hover {
        transform: translateY(-5px);
        border-color: var(--neon-blue);
        box-shadow: 0 5px 15px rgba(0, 212, 255, 0.2);
    }

    .theme-card p {
        font-family: 'Orbitron', sans-serif;
        font-size: 0.9rem;
        margin-bottom: 15px;
        color: var(--neon-blue);
    }

    .theme-card img {
        width: 100%;
        height: auto;
        border-radius: 8px;
        border: 1px solid rgba(255,255,255,0.1);
    }

    .current-theme-label {
        font-family: 'Orbitron', sans-serif;
        background: rgba(0, 212, 255, 0.1);
        padding: 10px;
        border-radius: 8px;
        color: #fff;
        display: inline-block;
        margin-bottom: 20px;
        border: 1px dashed var(--neon-blue);
    }
</style>

<div class="container-fluid pt-4 px-5">
    <h1 class="page-main-title h3 mb-4">Configurações de Tema</h1>

    <div class="card card-futuristic shadow mb-4">
        <div class="card-header-futuristic">
            <h6><i class="fa fa-th-large mr-2"></i> Selecionar Tema</h6>
        </div>
        <div class="card-body">

            <?php
                if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                    $selectedOption = $_POST['options'];
                    
                    // Lendo o JSON
                    $jsonData = file_get_contents('./a/rtx/Setting.json');
                    $data = json_decode($jsonData, true);

                    // Atualizando os dados do JSON
                    $data[0]["RTXSetting"] = "mLayout";
                    $data[0]["PanalData"] = $selectedOption;

                    // Salvando
                    $jsonData = json_encode($data, JSON_PRETTY_PRINT);
                    file_put_contents('./a/rtx/Setting.json', $jsonData);
                    
                    echo "<div class='current-theme-label' style='width: 100%; text-align: center;'>Configuração Aplicada: $selectedOption</div>";
                }

                // Lendo o JSON para exibir o tema atual
                $jsonData = file_get_contents('./a/rtx/Setting.json');
                $data = json_decode($jsonData, true);
                $current_layout = $data[0]["PanalData"];
            ?>

            <div class="selection-box">
                <p class="current-theme-label">TEMA ATIVO: <?php echo strtoupper($current_layout); ?></p>
                
                <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" class="form-inline justify-content-center">
                    <select name="options" id="options" class="form-control-futuristic mr-3">
                        <option value="theme_d" <?php if($current_layout == "theme_d") echo "selected"; ?>>Tema 1 (Padrão)</option>
                        <option value="theme_2" <?php if($current_layout == "theme_2") echo "selected"; ?>>Tema 2</option>
                        <option value="theme_3" <?php if($current_layout == "theme_3") echo "selected"; ?>>Tema 3</option>
                        <option value="theme_5" <?php if($current_layout == "theme_5") echo "selected"; ?>>Tema 4</option>
                    </select>
                    <button type="submit" class="btn btn-neon">Mudar Tema</button>
                </form>
            </div>

            <h5 class="page-main-title mb-4" style="font-size: 1rem;">Pre-visualização dos Temas</h5>
            
            <div class="themes-grid">
                <div class="theme-card">
                    <p>TEMA 1</p>
                    <img src="./rtx/layout/d.png" alt="theme_d">
                </div>

                <div class="theme-card">
                    <p>TEMA 2</p>
                    <img src="./rtx/layout/2.png" alt="theme_2">
                </div>   

                <div class="theme-card">
                    <p>TEMA 3</p>
                    <img src="./rtx/layout/3.png" alt="theme_3">
                </div>

                <div class="theme-card">
                    <p>TEMA 4</p>
                    <img src="./rtx/layout/5.png" alt="theme_5">
                </div>
            </div>

        </div>
    </div>
</div>

<?php
include "includes/footer.php";
?>