<?php
include "includes/header.php";
?>

<style>
    :root {
        --neon-blue: #00d4ff;
        --dark-bg: #06090c;
        --card-glass: rgba(13, 18, 24, 0.95);
        --border-glass: rgba(0, 212, 255, 0.2);
    }

    /* Elimina qualquer fundo branco remanescente */
    body, #wrapper, #content-wrapper, #content {
        background-color: var(--dark-bg) !important;
        color: #f8f9fc;
        font-family: 'Poppins', sans-serif;
    }

    .card-futuristic {
        background: var(--card-glass) !important;
        backdrop-filter: blur(15px);
        border: 1px solid var(--border-glass) !important;
        border-radius: 15px !important;
        box-shadow: 0 10px 30px rgba(0,0,0,0.5);
    }

    .card-header-futuristic {
        background: rgba(0, 212, 255, 0.03) !important;
        border-bottom: 1px solid var(--border-glass) !important;
        padding: 1.5rem !important;
    }

    .card-header-futuristic h6 {
        font-family: 'Orbitron', sans-serif;
        color: var(--neon-blue) !important;
        text-shadow: 0 0 10px var(--neon-blue);
        letter-spacing: 2px;
        margin: 0;
    }

    /* Estilo dos Radios e Labels */
    .method-selector {
        background: rgba(255, 255, 255, 0.05);
        padding: 15px;
        border-radius: 10px;
        border: 1px solid var(--border-glass);
        margin-bottom: 20px;
    }

    .custom-control-label {
        cursor: pointer;
        color: #e0e0e0;
    }

    /* Estilo da Imagem de Preview */
    .preview-container {
        text-align: center;
        margin: 20px 0;
    }

    .preview-image {
        border: 2px solid var(--neon-blue);
        border-radius: 12px;
        box-shadow: 0 0 20px rgba(0, 212, 255, 0.3);
        max-width: 100%;
        height: auto;
        background: #000;
    }

    /* Inputs e Botões */
    .form-control-futuristic {
        background: rgba(0, 0, 0, 0.5) !important;
        border: 1px solid var(--border-glass) !important;
        color: #fff !important;
        padding: 10px;
        border-radius: 8px;
    }

    .btn-neon {
        background: transparent;
        border: 1px solid var(--neon-blue);
        color: var(--neon-blue) !important;
        font-family: 'Orbitron', sans-serif;
        transition: 0.4s;
        padding: 10px 25px;
        border-radius: 8px;
        text-transform: uppercase;
    }

    .btn-neon:hover {
        background: var(--neon-blue);
        color: #000 !important;
        box-shadow: 0 0 20px var(--neon-blue);
    }

    #url-form {
        display: none;
    }

    h3 {
        font-size: 1.1rem;
        color: var(--neon-blue);
        margin-bottom: 15px;
    }
</style>

<div class="container-fluid pt-4 px-5">
    <h1 class="h3 mb-4" style="font-family: 'Orbitron'; color: #fff;">Gerenciamento de Background</h1>

    <div class="row">
        <div class="col-lg-10 mx-auto">
            <div class="card card-futuristic shadow mb-4">
                <div class="card-header-futuristic">
                    <h6><i class="fa fa-image mr-2"></i> ESCOLHA A IMAGEM DE FUNDO</h6>
                </div>
                <div class="card-body">
                    <?php
                    $jsonFilex = './a/rtx/image_filenames.json';
                    $jsonDatax = file_get_contents($jsonFilex);
                    $imageDatax = json_decode($jsonDatax, true);
                    
                    $filenamex = $imageDatax[0]['ImageName'];
                    $uploadmethord = $imageDatax[0]['Upload_type'];
                    
                    if ($uploadmethord == "by_file") {
                        $imageFilex = substr($filenamex, 1);
                        $methord = "Arquivo Local";
                    } elseif ($uploadmethord == "by_url") {
                        $imageFilex = $filenamex;
                        $methord = "Link Externo (URL)";
                    } else {
                        $imageFilex = "https://c4.wallpaperflare.com/wallpaper/159/71/731/errors-minimalism-typography-red-wallpaper-preview.jpg";
                        $methord = "Nenhum";
                    }

                    echo '<h3><i class="fas fa-info-circle mr-2"></i>Ativo: <span style="color:#fff">' . $methord . '</span></h3>';
                    ?>

                    <div class="method-selector">
                        <div class="custom-control custom-radio custom-control-inline">
                            <input type="radio" name="upload-type" id="upload-radio" class="custom-control-input" checked>
                            <label class="custom-control-label" for="upload-radio">Usar Arquivo Local</label>
                        </div>
                        <div class="custom-control custom-radio custom-control-inline">
                            <input type="radio" name="upload-type" id="url-radio" class="custom-control-input">
                            <label class="custom-control-label" for="url-radio">Usar URL Externa</label>
                        </div>
                    </div>

                    <div class="preview-container">
                        <img class="preview-image" src="<?php echo $imageFilex; ?>" alt="Background Preview" width="600">
                    </div>

                    <?php
                    if (isset($_POST['upload'])) {
                        $selectedFiles = ['logo.png', 'index.php', 'iimg.json', 'filenames.json', 'binding_dark.webp', 'bg.jpg', 'api.php', 'favicon.ico', 'logo_ne.png' , '.htaccess'];
                        $folderPath = './rtx/Img/ADM/';
                        $files = scandir($folderPath);
                        
                        foreach ($files as $file) {
                            if ($file !== '.' && $file !== '..') {
                                if (!in_array($file, $selectedFiles)) {
                                    unlink($folderPath . $file);
                                }
                            }
                        }
                        
                        if (isset($_FILES['image'])) {
                            $file = $_FILES['image'];
                            $fileType = $file['type'];
                            $fileTemp = $file['tmp_name'];
                            $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
                            
                            if (in_array($fileType, $allowedTypes)) {
                                $uploadPath = './rtx/Img/ADM/';
                                $fileName = uniqid() . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
                                $destination = $uploadPath . $fileName;
                                
                                if (move_uploaded_file($fileTemp, $destination)) {
                                    $jsonData = json_encode([["ImageName" => "../rtx/Img/ADM/" . $fileName, 'Upload_type' => 'by_file']]);
                                    file_put_contents('./a/rtx/image_filenames.json', $jsonData);
                                    echo "<script>window.location.href='mRTXBGImage.php';</script>";
                                }
                            }
                        }
                    }

                    if (isset($_POST['url-submit'])) {
                        $imageUrl = $_POST['image-url'];
                        if (filter_var($imageUrl, FILTER_VALIDATE_URL)) {
                            $jsonData = json_encode([['ImageName' => $imageUrl, 'Upload_type' => 'by_url']]);
                            file_put_contents('./a/rtx/image_filenames.json', $jsonData);
                            echo "<script>window.location.href='mRTXBGImage.php';</script>";
                        }
                    }
                    ?>

                    <div id="upload-form" class="mt-4">
                        <form method="post" enctype="multipart/form-data">
                            <label class="d-block mb-2">Selecione uma imagem (JPG, PNG, GIF):</label>
                            <input class="form-control-futuristic mb-3" type="file" name="image" accept="image/*" style="width: 100%;">
                            <button class="btn btn-neon" type="submit" name="upload"><i class="fas fa-upload mr-2"></i>Fazer Upload</button>
                        </form>
                    </div>

                    <div id="url-form" class="mt-4">
                        <form method="post">
                            <label class="d-block mb-2">Cole a URL da imagem abaixo:</label>
                            <input class="form-control-futuristic mb-3" type="text" name="image-url" placeholder="https://exemplo.com/imagem.jpg" style="width: 100%;">
                            <button class="btn btn-neon" type="submit" name="url-submit"><i class="fas fa-link mr-2"></i>Salvar por URL</button>
                        </form>
                    </div>

                    <script>
                        const uploadRadio = document.getElementById('upload-radio');
                        const urlRadio = document.getElementById('url-radio');
                        const uploadForm = document.getElementById('upload-form');
                        const urlForm = document.getElementById('url-form');

                        uploadRadio.addEventListener('change', () => {
                            uploadForm.style.display = 'block';
                            urlForm.style.display = 'none';
                        });

                        urlRadio.addEventListener('change', () => {
                            uploadForm.style.display = 'none';
                            urlForm.style.display = 'block';
                        });
                    </script>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
include "includes/footer.php";
?>